<?php

// Marquee ----------------------------------------------
vc_map( array (
    'base' 			=> 'pix_marquee',
    'name' 			=> __('Marquee', 'pixfort-core'),
    'category' 		=> __('pixfort', 'pixfort-core'),
    "weight"	=> "1000",
    'class'         => 'pixfort_element',
    'icon' 			=> PIX_CORE_PLUGIN_URI . 'functions/images/elements/marquee.gif',
    'description' 	=> __('Create Marquee text effect', 'pixfort-core'),
    'params' 		=> array (

        array(
            'type' => 'param_group',
            'value' => '',
            'param_name' => 'items',
            'heading' 		=> __('Text', 'pixfort-core'),
            'description' 	=> __('Add each phrase in the desired order.', 'pixfort-core'),
            'params' => array(
                array(
                    "type" => "dropdown",
                    "heading" => __( "Item type", "pixfort-core" ),
                    "param_name" => "item_type",
                    "value" => array(
                        "Text" => "text",
                        "Image" => "image",
                        "Icon" => "icon",
                        "Duo tone icon" => "duo_icon"
                    ),
                ),
                array (
                    'param_name' 	=> 'text',
                    'type' 			=> 'textfield',
                    'heading' 		=> __('Text', 'pixfort-core'),
                    'admin_label'	=> true,
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "text"
                    ),
                ),
                array(
                    "type" => "checkbox",
                    "heading" => __( "Title format", "pixfort-core" ),
                    "param_name" => "bold",
                    "value" => array("Bold" => "font-weight-bold"),
                    // "std" => "font-weight-bold"
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "text"
                    ),
                ),
                array(
                    "type" => "checkbox",
                    "param_name" => "italic",
                    "value" => array("Italic" => "font-italic",),
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "text"
                    ),
                ),
                array(
                    "type" => "checkbox",
                    "param_name" => "heading_font",
                    "std" => "heading-font",
                    "value" => array("Heading font" => "heading-font",),
                    'save_always' => true,
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "text"
                    ),
                ),
                array(
                    "type" => "checkbox",
                    'param_name' 	=> 'text_image',
                    'type' 			=> 'attach_image',
                    'heading' 		=> __('Use image as text color', 'pixfort-core'),
                    'description' 	=> __('The image will be visible inside the text characters.', 'pixfort-core'),
                    'admin_label'	=> false,
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => 'text'
                    ),
                ),


                array(
                    'type'        => 'pix_icons_select',
                    'heading'  => 'Duo tone icons',
                    'param_name'  => 'pix_duo_icon',
                    "class" => "my_param_field",
                    'value'       => '0',
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "duo_icon"
                    ),
                ),
                array (
                    'type' => 'iconpicker',
                    'heading' => __( 'Icon', 'pixfort-core' ),
                    'param_name' => 'icon',
                    'settings' => array(
                        'emptyIcon' => true, // default true, display an "EMPTY" icon?
                        'type' => 'pix-icons',
                        'iconsPerPage' => 200, // default 100, how many icons per/page to display
                    ),
                    'description' => __( 'Select icon from library.', 'pixfort-core' ),
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "icon"
                    ),
                ),
                array (
                    'param_name' 	=> 'image',
                    'type' 			=> 'attach_image',
                    'heading' 		=> __('Image', 'pixfort-core'),
                    'admin_label'	=> false,
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "image"
                    ),
                ),

                array (
                    'param_name' 	=> 'image_size',
                    'type' 			=> 'textfield',
                    'heading' 		=> __('Image Size', 'pixfort-core'),
                    'description' => __( 'The size of the image (in pixels), leave empty for full size.', 'pixfort-core' ),
                    'admin_label'	=> false,
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => "image"
                    ),
                ),
        
                array(
                    "type" => "checkbox",
                    "heading" => __( "Circle image", "pixfort-core" ),
                    "param_name" => "circle",
                    "value" => __( "Yes", "pixfort-core" ),
                    "dependency" => array(
                        "element" => "item_type",
                        "value" => 'image'
                    ),
                ),

                array (
                    'param_name' 	=> 'link',
                    'type' 			=> 'textfield',
                    'heading' 		=> __('Link', 'pixfort-core'),
                    'admin_label'	=> true,
                ),
                array(
                    "type" => "checkbox",
                    "heading" => __( "Open in a new tab", "pixfort-core" ),
                    "param_name" => "target",
                    "value" => __( "Yes", "pixfort-core" ),
                    "dependency" => array(
                        "element" => "link",
                        "not_empty" => true
                    ),
                ),


            )
        ),

        
        array (
            'param_name' 	=> 'content_color',
            'type' 			=> 'dropdown',
            'heading' 		=> __('Content color', 'pixfort-core'),
            'admin_label'	=> false,
            'value' 		=> $colors,
            'std'			=> '',

        ),


        array (
            'param_name' 	=> 'content_custom_color',
            'type' 			=> 'colorpicker',
            'heading' 		=> __('Content custom color', 'pixfort-core'),
            'admin_label'	=> false,
            "dependency" => array(
                  "element" => "content_color",
                  "value" => "custom"
              ),
        ),

        array (
            'param_name' 	=> 'content_size',
            'type' 			=> 'dropdown',
            'heading' 		=> __('Content size', 'pixfort-core'),
            'admin_label'	=> false,
            'value' 		=> array(
                __('H1','pixfort-core') 	=> 'h1',
                __('H2','pixfort-core')	    => 'h2',
                __('H3','pixfort-core')	    => 'h3',
                __('H4','pixfort-core')	    => 'h4',
                __('H5','pixfort-core')	    => 'h5',
                __('H6','pixfort-core')	    => 'h6',
                __('Custom','pixfort-core')	    => 'custom',
            ),
        ),

        array (
            'param_name' 	=> 'display',
            'type' 			=> 'dropdown',
            'heading' 		=> __('Bigger Text', 'pixfort-core'),
            'description' 	=> __('Larger text size to stand out.', 'pixfort-core'),
            'admin_label'	=> false,
            'value'			=> array_flip(array(
                ''		=> 'None',
                'display-1'		=> 'Display 1',
                'display-2'		=> 'Display 2',
                'display-3'		=> 'Display 3',
                'display-4'		=> 'Display 4',
            )),
            "dependency" => array(
                "element" => "content_size",
                "value" => array('h1', 'h2', 'h3', 'h4', 'h5', 'h6')
            ),
        ),

        array (
            'param_name' 	=> 'content_custom_size',
            'type' 			=> 'textfield',
            'heading' 		=> __('Content custom text Size', 'pixfort-core'),
            'admin_label'	=> false,
        ),

        
        array(
            "type" => "checkbox",
            "heading" => __( "Reverse direction", "pixfort-core" ),
            "param_name" => "reversed",
            "value" => array("Yes" => "pix-reversed"),
        ),
        array(
            "type" => "checkbox",
            "heading" => __( "Pause on hover", "pixfort-core" ),
            "param_name" => "pause_on_hover",
            "value" => array("Yes" => "pix-pause-hover"),
        ),

        array(
            "type" => "checkbox",
            "heading" => __( "Enable Gray effect", "pixfort-core" ),
            "param_name" => "pix_gray_effect",
            "value" => array("Yes" => "pix-gray-effect"),
        ),
        array(
            "type" => "checkbox",
            "heading" => __( "Color Gray item on hover", "pixfort-core" ),
            "param_name" => "pix_colored_hover",
            "value" => array("Yes" => "pix-colored-hover"),
            "dependency" => array(
                "element" => "pix_gray_effect",
                "value" => array('pix-gray-effect')
            ),
        ),

        array (
            'param_name' 	=> 'speed',
            'type' 			=> 'textfield',
            'heading' 		=> __('Speed (in seconds)', 'pixfort-core'),
            'description' 	=> __('The number of seconds to complete one full rotation (leave empty to use default 10).', 'pixfort-core'),
            'admin_label'	=> true,
        ),

        array (
            'param_name' 	=> 'element_id',
            'type' 			=> 'textfield',
            'heading' 		=> __('Element ID', 'pixfort-core'),
            'admin_label'	=> true,
            'settings' => array(
                'auto_generate' => true,
            ),
            'group'         => "Advanced",
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'Css', 'essentials-core' ),
          'param_name' => 'css',
          'group' => __( 'Design options', 'essentials-core' ),
          ),




    )
));

?>
